/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.kop.app.LogoComfortKOP;
import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.ApplicationSurface;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.InternApplicationSurface;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.WindowManager;
import DE.siemens.ad.logo.app.comp.BorderPanelPane;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.RolloverButton;
import DE.siemens.ad.logo.dialog.comp.ProgressIndicator;
import DE.siemens.ad.logo.dialog.comp.TableSorter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Link;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.logo.util.WaitCursorThread;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.BlockIfcFigure;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionConstraint;
import DE.siemens.ad.pdraw.figures.constraints.ConnectorConstraint;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class ComparatorPanel
extends DataInputPanel {
    protected JComboBox fInputLeft;
    protected JComboBox fInputRigth;
    protected JButton fCompareButton;
    protected JPanel fButtonPanel;
    protected JSplitPane fDrawingPanel;
    protected JPanel fInputPanel;
    protected BorderPanelPane fOutputPanel;
    protected JScrollPane fTablePanel;
    protected JTable fTable;
    protected Editor fEditor;
    protected List fViews;
    private View fLeftView;
    private View fRightView;
    private final int MAX_DEFAULT_TABLE_HEIGHT = 150;
    private final int MIN_DEFAULT_TABLE_HEIGHT = 80;
    private InternApplicationSurface fLeftApplicationSurface;
    private InternApplicationSurface fRightApplicationSurface;
    private DifferenceTableModel fDifferenceTableModel;
    private WiringDiagram fLeftWiringDiagram;
    private WiringDiagram fRightWiringDiagram;
    private RolloverButton fPreviousDifference;
    private RolloverButton fNextDifference;
    private int fLastSelectedItemRight = 0;
    private int fLastSelectedIndexLeft = 0;

    private ComparatorPanel() {
    }

    public ComparatorPanel(Editor editor, List views) {
        this();
        this.fEditor = editor;
        this.fViews = views;
        this.initialize();
    }

    private String getSelectedText(JComboBox listbox) {
        Object value = listbox.getSelectedItem();
        String result = value.toString();
        if (value instanceof View) {
            View view = (View)value;
            result = Util.getCuttedFilename(view.getModel().getFile(), 40);
        }
        return result;
    }

    protected JSplitPane getDrawingPanel() {
        if (this.fDrawingPanel == null) {
            this.fDrawingPanel = new JSplitPane(1);
            this.fDrawingPanel.setDividerLocation(0.5);
            this.fDrawingPanel.setResizeWeight(0.5);
            this.fDrawingPanel.setOneTouchExpandable(true);
            this.fDrawingPanel.setDividerSize(8);
        }
        return this.fDrawingPanel;
    }

    protected JPanel getInputPanel() {
        if (this.fInputPanel == null) {
            this.fViews.add(Language.getString("hardware.family.name", "Hardware"));
            Vector displayList = new Vector(this.fViews);
            this.fInputLeft = new JComboBox(new DefaultComboBoxModel(displayList));
            this.fInputRigth = new JComboBox(new DefaultComboBoxModel(displayList));
            ViewComboBoxRenderer viewComboBoxRenderer = new ViewComboBoxRenderer();
            this.fInputLeft.setRenderer(viewComboBoxRenderer);
            this.fInputRigth.setRenderer(viewComboBoxRenderer);
            int index = this.fViews.indexOf(Application.getInstance().getMdiManager().getActiveTopLevelView());
            this.fInputLeft.setSelectedIndex(index);
            if (--index > -1) {
                this.fInputRigth.setSelectedIndex(index);
            } else {
                this.fInputRigth.setSelectedIndex(index + 2);
            }
            this.fInputLeft.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    ComparatorPanel.this.inputLeft_ValueChanged();
                    ComparatorPanel.this.fLastSelectedIndexLeft = ComparatorPanel.this.fInputLeft.getSelectedIndex();
                }
            });
            this.fInputRigth.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    ComparatorPanel.this.inputRight_ValueChanged();
                    ComparatorPanel.this.fLastSelectedItemRight = ComparatorPanel.this.fInputRigth.getSelectedIndex();
                }
            });
            JLabel label1 = new JLabel(Language.getString("comparePanel.compareLabel", "Compare:"));
            JLabel label2 = new JLabel(Language.getString("comparePanel.with", "with:"));
            this.fCompareButton = new JButton(Language.getString("comparePanel.compareButton", "Start"));
            this.fCompareButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    Runnable r = new Runnable(){

                        public void run() {
                            ComparatorPanel.this.compareButtonPressed();
                        }
                    };
                    new WaitCursorThread(r, ComparatorPanel.this).run();
                }
            });
            this.fInputPanel = new JPanel();
            this.fInputPanel.setLayout(new BoxLayout(this.fInputPanel, 0));
            this.fInputPanel.add(label1);
            this.fInputPanel.add(this.fInputLeft);
            this.fInputPanel.add(label2);
            this.fInputPanel.add(this.fInputRigth);
            this.fInputPanel.add(this.fCompareButton);
        }
        return this.fInputPanel;
    }

    protected BorderPanelPane getOutputPanel() {
        if (this.fOutputPanel == null) {
            this.fOutputPanel = new BorderPanelPane("North");
            this.fOutputPanel.getBorderPanel().setTitle(Language.getString("comparePanel.differences", "Differences"));
            this.fOutputPanel.getBorderPanel().add(this.getTablePanel());
            this.fOutputPanel.getViewPanel().add(this.getDrawingPanel());
            this.fOutputPanel.getBorderPanel().setClosable(false);
            JComponent toolbarPanel = this.fOutputPanel.getBorderPanel().getToolbarPanel();
            this.fNextDifference = new RolloverButton(Global.getIcon("Next.gif"));
            this.fNextDifference.setToolTipText(Language.getString("comparePanel.nextDifference"));
            this.fNextDifference.setMargin(new Insets(0, 0, 0, 0));
            toolbarPanel.add(this.fNextDifference);
            this.fNextDifference.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ComparatorPanel.this.nextDifferenceButtonPressed();
                }
            });
            this.fPreviousDifference = new RolloverButton(Global.getIcon("Previous.gif"));
            this.fPreviousDifference.setToolTipText(Language.getString("comparePanel.previousDifference"));
            this.fPreviousDifference.setMargin(new Insets(0, 0, 0, 0));
            toolbarPanel.add(this.fPreviousDifference);
            this.fPreviousDifference.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ComparatorPanel.this.previousDifferenceButtonPressed();
                }
            });
        }
        return this.fOutputPanel;
    }

    protected JScrollPane getTablePanel() {
        if (this.fTablePanel == null) {
            this.fTable = new JTable();
            this.fTable.setSelectionMode(0);
            this.fTable.setDefaultRenderer(Object.class, new TableCellTextAreaRenderer(this.fTable));
            ListSelectionModel rowSM = this.fTable.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (!lsm.isSelectionEmpty()) {
                        int selectedRow = lsm.getMinSelectionIndex();
                        ComparatorPanel.this.tableSelectionChanged(selectedRow);
                    }
                }
            });
            this.fTablePanel = new JScrollPane(this.fTable);
            this.fTablePanel.setMinimumSize(new Dimension(200, 100));
        }
        return this.fTablePanel;
    }

    public Dimension getSize() {
        return new Dimension(640, 480);
    }

    public String getTitle() {
        return Language.getString("comparePanel.title", "Compare");
    }

    private void tableSelectionChanged(int selectedRow) {
        if (this.fTable == null) {
            return;
        }
        this.enable_disableSelectionButton(selectedRow);
        selectedRow = ((TableSorter)this.fTable.getModel()).getRowInOriginalTable(selectedRow);
        if (this.fDifferenceTableModel != null) {
            Object[] links = this.fDifferenceTableModel.getLinks(++selectedRow);
            this.leftSource_SelectionChanged(links[0]);
            this.rightSource_SelectionChanged(links[1]);
        }
    }

    private void enable_disableSelectionButton(int selectedRow) {
        this.fNextDifference.setEnabled(selectedRow + 1 != this.fTable.getRowCount());
        this.fPreviousDifference.setEnabled(selectedRow - 1 >= 0);
    }

    protected void leftSource_SelectionChanged(Object element) {
        this.sourceView_SelectionChanged(element, (LogoDrawingView)this.fLeftView);
    }

    protected void rightSource_SelectionChanged(Object element) {
        this.sourceView_SelectionChanged(element, (LogoDrawingView)this.fRightView);
    }

    protected void sourceView_SelectionChanged(Object element, LogoDrawingView view) {
        view.clearSelection();
        if (element instanceof Collection) {
            Iterator iterator = ((Collection)element).iterator();
            while (iterator.hasNext()) {
                this.select(iterator.next(), view);
            }
        } else {
            this.select(element, view);
        }
        view.repaint();
    }

    private void select(Object element, LogoDrawingView view) {
        Link linkObject;
        Object linkClass;
        if (element instanceof Link && (linkClass = (linkObject = (Link)element).getLinkClass()) == BlockConnector.class) {
            BlockConnector[] linkArray = (BlockConnector[])linkObject.getLink();
            if (linkArray.length > 1) {
                BlockConnector inCon = linkArray[0];
                BlockConnector outCon = linkArray[1];
                BlockIfcFigure figure = ((LogoDrawing)view.getModel()).getBlockIfcFigure(outCon);
                Collection lines = null;
                try {
                    lines = ((ConnectorConstraint)figure.getConstraint()).getConnectionLineConstraints();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                if (lines != null) {
                    for (ConnectionConstraint constraint : lines) {
                        FigureConstraint figureConstraint = ((FigureConstraint)((Object)constraint)).getTopLevelConstraint();
                        if (((ConnectionConstraint)((Object)figureConstraint)).getInBlockConnector() != inCon || figureConstraint == null) continue;
                        view.addToSelection(figureConstraint);
                        view.scrollToFigure(figure);
                    }
                }
            } else {
                BlockConnector inCon = linkArray[0];
                BlockIfcFigure figure = ((LogoDrawing)view.getModel()).getBlockIfcFigure(inCon);
                this.addFigure(view, figure);
            }
        }
        if (element instanceof Block) {
            BlockFigure figure = ((LogoDrawing)view.getModel()).getBlockFigure((Block)element);
            this.addFigure(view, figure);
        }
    }

    private void addFigure(LogoDrawingView view, Figure figure) {
        if (figure != null) {
            view.addToSelection(figure);
            view.scrollToFigure(figure);
        }
    }

    protected void fillRightSourcePanel() {
        WiringDiagram wd = this.getSelectedWiringDiagram(this.fInputRigth, this.fInputLeft);
        if (wd == this.fRightWiringDiagram || wd == null) {
            return;
        }
        this.fRightWiringDiagram = wd;
        try {
            this.removeObserverFromDrawing(this.fRightApplicationSurface);
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
            this.fRightView = (View)this.fViews.get(this.fInputRigth.getSelectedIndex());
            this.fRightApplicationSurface = new InternApplicationSurface(window);
            LogoComfort rightEditor = (LogoComfort)this.fRightView.getEditor().getClass().newInstance();
            rightEditor.init(this.fEditor.getApplication());
            rightEditor.newDocument();
            this.fRightApplicationSurface.setEditor(rightEditor);
            rightEditor.setStandardToolBarVisible(false);
            rightEditor.setStatuslineVisible(false);
            WindowManager rightWindowManager = this.fRightApplicationSurface.getWindowManager();
            if (rightWindowManager.isWindowCreated("toolTreePanel")) {
                rightWindowManager.getBorderPanel("toolTreePanel", "West").setMinimized(true);
            }
            rightEditor.setDrawing((LogoDrawing)this.fRightView.getModel());
            this.fRightView = rightEditor.getView();
            this.getDrawingPanel().setRightComponent(this.fRightApplicationSurface);
            this.disableOnlineOfflineTest(rightEditor);
            this.SetDrawingLocked(rightEditor, this.fInputRigth);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void fillLeftSourcePanel() {
        WiringDiagram wd = this.getSelectedWiringDiagram(this.fInputLeft, this.fInputRigth);
        if (wd == this.fLeftWiringDiagram || wd == null) {
            return;
        }
        this.fLeftWiringDiagram = wd;
        try {
            this.removeObserverFromDrawing(this.fLeftApplicationSurface);
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
            this.fLeftView = (View)this.fViews.get(this.fInputLeft.getSelectedIndex());
            this.fLeftApplicationSurface = new InternApplicationSurface(window);
            LogoComfort leftEditor = (LogoComfort)this.fLeftView.getEditor().getClass().newInstance();
            leftEditor.init(this.fEditor.getApplication());
            leftEditor.newDocument();
            this.fLeftApplicationSurface.setEditor(leftEditor);
            leftEditor.setStandardToolBarVisible(false);
            leftEditor.setStatuslineVisible(false);
            WindowManager leftWindowManager = this.fLeftApplicationSurface.getWindowManager();
            if (leftWindowManager.isWindowCreated("toolTreePanel")) {
                leftWindowManager.getBorderPanel("toolTreePanel", "West").setMinimized(true);
            }
            leftEditor.setDrawing((LogoDrawing)this.fLeftView.getModel());
            this.fLeftView = leftEditor.getView();
            this.getDrawingPanel().setLeftComponent(this.fLeftApplicationSurface);
            this.disableOnlineOfflineTest(leftEditor);
            this.SetDrawingLocked(leftEditor, this.fInputLeft);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(700, 500);
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInputPanel(), "North");
        this.add((Component)this.getOutputPanel(), "Center");
        this.fillLeftSourcePanel();
        this.fillRightSourcePanel();
        this.setCompareButtonEnableDisable();
    }

    protected void inputLeft_ValueChanged() {
        this.setTable(null);
        this.fillLeftSourcePanel();
        this.setCompareButtonEnableDisable();
    }

    private void setCompareButtonEnableDisable() {
        this.fCompareButton.setEnabled(null != this.fLeftWiringDiagram && null != this.fRightWiringDiagram && this.fLeftWiringDiagram != this.fRightWiringDiagram && this.fLeftWiringDiagram.getClass() == this.fRightWiringDiagram.getClass());
    }

    protected void nextDifferenceButtonPressed() {
        int selectedRow = this.fTable.getSelectedRow();
        if (++selectedRow < this.fTable.getRowCount()) {
            this.fTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            this.fTable.scrollRectToVisible(this.fTable.getCellRect(selectedRow, 0, true));
        }
    }

    protected void previousDifferenceButtonPressed() {
        int selectedRow = this.fTable.getSelectedRow();
        if (--selectedRow <= this.fTable.getRowCount() && selectedRow >= 0) {
            this.fTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            this.fTable.scrollRectToVisible(this.fTable.getCellRect(selectedRow, 0, true));
        }
    }

    protected void inputRight_ValueChanged() {
        this.fillRightSourcePanel();
        this.setCompareButtonEnableDisable();
        this.setTable(null);
    }

    protected void compareButtonPressed() {
        this.fillLeftSourcePanel();
        this.fillRightSourcePanel();
        boolean doCompare = true;
        if (this.fLeftWiringDiagram != null && this.fRightWiringDiagram != null) {
            DifferenceTableModel tableModel;
            if (this.fLeftWiringDiagram instanceof WiringDiagramKop && (tableModel = this.fLeftWiringDiagram.getFup().compareLogicalTo(this.fRightWiringDiagram.getFup())).getRowCount() == 0) {
                doCompare = false;
            }
            if (doCompare) {
                this.setTable(this.fLeftWiringDiagram.compareLogicalTo(this.fRightWiringDiagram));
            }
        }
        this.fCompareButton.setEnabled(false);
    }

    private void setTable(DifferenceTableModel table) {
        if (table == null) {
            this.fDifferenceTableModel = new DifferenceTableModel(Language.getString("comparePanel.table.description", "Description"), this.getSelectedText(this.fInputLeft), this.getSelectedText(this.fInputRigth));
        } else {
            String[] arr = new String[]{Language.getString("comparePanel.table.description", "Description"), this.getSelectedText(this.fInputLeft), this.getSelectedText(this.fInputRigth)};
            this.fDifferenceTableModel = table;
            this.fDifferenceTableModel.setHeader(arr);
        }
        TableSorter sortedDifferenceModel = new TableSorter(this.fDifferenceTableModel);
        this.fTable.setModel(sortedDifferenceModel);
        sortedDifferenceModel.addMouseListenerToHeaderInTable(this.fTable);
        int optTableHeigth = this.getOptTableHeight();
        Dimension newDim = new Dimension(300, 150 < optTableHeigth ? 150 : optTableHeigth);
        this.getOutputPanel().getBorderPanel().setSize(newDim);
        if (this.fTable.getRowCount() > 0) {
            this.nextDifferenceButtonPressed();
        } else {
            this.fNextDifference.setEnabled(false);
            this.fPreviousDifference.setEnabled(false);
        }
    }

    private int getOptTableHeight() {
        int optTableHeigth = 100;
        optTableHeigth = this.fTable.getTableHeader().getHeight() == 0 ? (optTableHeigth += 80) : (optTableHeigth += this.fTable.getTableHeader().getHeight());
        optTableHeigth += this.fTable.getRowCount() * this.fTable.getRowMargin();
        for (int i = 0; i < this.fTable.getRowCount(); ++i) {
            optTableHeigth += this.fTable.getRowHeight(i);
        }
        return optTableHeigth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WiringDiagram getSelectedWiringDiagram(final JComboBox listbox, JComboBox otherListbox) {
        WiringDiagram wd = null;
        Object selectedItem = listbox.getSelectedItem();
        if (selectedItem instanceof View) {
            wd = ((LogoDrawing)((View)selectedItem).getModel()).getWiringDiagram();
        } else {
            Object obj = this.fViews.get(this.fViews.size() - 1);
            if (obj instanceof View) {
                wd = ((LogoDrawing)((View)obj).getModel()).getWiringDiagram();
            } else {
                if (otherListbox.getSelectedItem() instanceof View) {
                    Log.printStartSequence(Language.getString("compare.toRemote", "Compare with Device"));
                    Application application = Application.getInstance();
                    Editor editor = ((View)otherListbox.getSelectedItem()).getEditor();
                    View view = application.createView(editor.getEditorInfo().getEditorClassName());
                    if (view != null) {
                        LogoComfort logoComfort = (LogoComfort)view.getEditor();
                        ProgressIndicator progressFrame = new ProgressIndicator(editor.getApplicationSurface().getWindow());
                        progressFrame.setTitle(Language.getString("msg.com.uploadFrom", "Device --> PC", Language.getString("hardware.family.name", "Device")));
                        progressFrame.setNote(Language.getString("msg.datatransfer", "Tranfering data..."));
                        try {
                            if (logoComfort.upload(progressFrame)) {
                                this.fViews.set(this.fViews.size() - 1, view);
                                wd = ((LogoDrawing)logoComfort.drawing()).getWiringDiagram();
                            }
                        }
                        finally {
                            progressFrame.dispose();
                        }
                    }
                }
                if (wd == null) {
                    if (listbox == this.fInputLeft) {
                        final int value = this.fLastSelectedIndexLeft;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                listbox.setSelectedIndex(value);
                            }
                        });
                    } else {
                        final int value = this.fLastSelectedItemRight;
                        System.out.println("gesichert " + value);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                System.out.println("boxSelection " + value);
                                listbox.setSelectedIndex(value);
                            }
                        });
                    }
                }
            }
        }
        return wd;
    }

    public void closeEvent() {
        super.closeEvent();
        this.removeObserverFromDrawing(this.fLeftApplicationSurface);
        this.removeObserverFromDrawing(this.fRightApplicationSurface);
    }

    private void removeObserverFromDrawing(ApplicationSurface appSurface) {
        if (appSurface != null) {
            ((LogoDrawing)appSurface.getEditor().getView().getModel()).deleteObserver((LogoDrawingView)appSurface.getEditor().getView());
        }
    }

    private void disableOnlineOfflineTest(LogoComfort editor) {
        if (editor instanceof LogoComfortKOP) {
            editor.getActionFactory().getAction("OnlineTestToolAction").setActivated(false);
            editor.getActionFactory().getAction("SimulationToolAction").setActivated(false);
        } else {
            editor.getActionFactory().getAction("OnlineTestToolAction").setActivated(false);
            editor.getActionFactory().getAction("SimulationToolAction").setActivated(false);
        }
    }

    private void SetDrawingLocked(LogoComfort editor, JComboBox combo) {
        Boolean locked = false;
    }

    protected class TableCellTextAreaRenderer
    extends JTextArea
    implements TableCellRenderer {
        public TableCellTextAreaRenderer(JTable owner) {
            this.setFont(owner.getFont());
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int maxPreferredHeight = 0;
            for (int i = 0; i < table.getColumnCount(); ++i) {
                this.setText("" + table.getValueAt(row, i));
                maxPreferredHeight = Math.max(maxPreferredHeight, this.getPreferredSize().height);
            }
            if (table.getRowHeight(row) != maxPreferredHeight) {
                table.setRowHeight(row, maxPreferredHeight);
            }
            this.setText(value == null ? "" : value.toString());
            if (isSelected) {
                if (!this.getBackground().equals(table.getSelectionBackground())) {
                    this.setBackground(table.getSelectionBackground());
                    this.setForeground(table.getSelectionForeground());
                }
            } else if (!this.getBackground().equals(table.getBackground())) {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }

    protected class ViewComboBoxRenderer
    extends DefaultListCellRenderer {
        protected ViewComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof View) {
                View view = (View)value;
                this.setIcon(view.getEditor().getEditorInfo().getIcon());
                this.setText(Util.getCuttedFilename(view.getModel().getFile(), 40));
            }
            return this;
        }
    }
}

